/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Button;
import control.MainControl;
import data.Constants;
import java.util.ArrayList;
import main.Game;
import model.PlayerModel;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import view.Fonts;
import view.KeyboardInput;
import view.StaticDrawer;

public class MenuControl {
    public static float offsetX = 0.0f;
    public static float offsetY = 0.0f;
    public static float yVel = 0.0f;
    public static float xVel = 0.0f;
    public static float fade = 0.0f;
    static int fadeOffX = 0;
    static int fadeOffY = 0;
    ArrayList<Button> buttonList = new ArrayList();
    String sSongName = Constants.SONG_TO_USE.substring(0, Constants.SONG_TO_USE.length());
    Button titleButton = new Button(Constants.VIEW_WIDTH / 2, 85, Constants.GAME_NAME, 1.0f);
    Button playButton = new Button(Constants.VIEW_WIDTH / 2, (int)((double)(Constants.VIEW_HEIGHT / 7) * 2.5), "play", 1.0f);
    Button exitButton = new Button(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 7 * 6, "exit", 1.0f);
    Button pickSongButton = new Button(Constants.VIEW_WIDTH / 6 * 5, (int)((double)(Constants.VIEW_HEIGHT / 7) * 3.5), "pick song", 1.0f);
    Button songNameButton = new Button(Constants.VIEW_WIDTH / 6 * 5, (int)((double)(Constants.VIEW_HEIGHT / 7) * 3.5 + 35.0), this.sSongName, 0.33f);
    Button scoreButton = new Button(Constants.VIEW_WIDTH / 6, (int)((double)(Constants.VIEW_HEIGHT / 7) * 3.5), "scores", 1.0f);
    public static String error;
    public static float errorFade;
    private static final long lWaitBeforeFloatToPlay = 40000L;
    private static final float fSlowDistFromExit;

    static {
        errorFade = 0.0f;
        fSlowDistFromExit = (float)Constants.VIEW_HEIGHT * 130.0f / 720.0f;
    }

    public void initialize() {
        offsetX = 0.0f;
        offsetY = 0.0f;
        yVel = 0.0f;
        xVel = 0.0f;
        this.buttonList.add(this.titleButton);
        this.buttonList.add(this.playButton);
        this.buttonList.add(this.exitButton);
        this.buttonList.add(this.songNameButton);
        this.buttonList.add(this.scoreButton);
        this.buttonList.add(this.pickSongButton);
    }

    public void update() {
        if (error != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef(offsetX, offsetY, 0.0f);
            float w = Fonts.getWidth(error, 0.5);
            float h = Fonts.getHeight(error, 0.5);
            int x = Constants.VIEW_WIDTH / 2;
            int y = Constants.VIEW_HEIGHT * 9 / 13;
            Fonts.drawText(x, y, 0.5, error, true);
            StaticDrawer.fade((float)x - w / 2.0f - 10.0f, (float)y - h / 2.0f - 10.0f, w + 20.0f, h + 20.0f, errorFade);
            errorFade = (float)((double)errorFade + 0.01);
            if (errorFade >= 1.0f) {
                error = null;
                errorFade = 0.0f;
            }
            GL11.glPopMatrix();
        }
        this.draw();
        this.applyFriction();
        Button.xOffset = (int)(offsetX += xVel);
        Button.yOffset = (int)(offsetY += yVel);
        this.songNameButton.setText(Constants.SONG_TO_USE);
        boolean bCollisionDetected = false;
        for (Button b : this.buttonList) {
            bCollisionDetected = b.checkCollision(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2);
            if (b == this.songNameButton || b == this.titleButton || !bCollisionDetected) continue;
            this.executeButtonAction(b);
        }
        this.drawScoreAlpha();
        if (Constants.bSlowToExit) {
            this.slowToExit();
        }
        if (Constants.bFloatToPlay) {
            this.floatToPlay();
        }
    }

    private void floatToPlay() {
        float xDifToPlay = this.playButton.getXCenter() - PlayerModel.x;
        float yDifToPlay = this.playButton.getYCenter() - PlayerModel.y;
        if (System.currentTimeMillis() - KeyboardInput.getLastMoveTime() > 40000L) {
            float fBaseMoveSpeed = 0.5f;
            float xMoveSpeed = Math.abs(xDifToPlay) / (Math.abs(xDifToPlay) + Math.abs(yDifToPlay)) * fBaseMoveSpeed;
            float yMoveSpeed = Math.abs(yDifToPlay) / (Math.abs(xDifToPlay) + Math.abs(yDifToPlay)) * fBaseMoveSpeed;
            if (Math.abs(xDifToPlay) > 5.0f + this.playButton.getButtonWidth() * 0.75f) {
                float f = xVel = xDifToPlay > 0.0f ? -xMoveSpeed : xMoveSpeed;
            }
            if (Math.abs(yDifToPlay) > 5.0f + this.playButton.getButtonHeight()) {
                yVel = yDifToPlay > 0.0f ? -yMoveSpeed : yMoveSpeed;
            }
        }
    }

    private void slowToExit() {
        float fFadeAlpha = 0.0f;
        float fPlayerDistFromExit = this.getDistFromExit(PlayerModel.x, PlayerModel.y);
        if (fPlayerDistFromExit < fSlowDistFromExit) {
            fFadeAlpha = 1.0f - fPlayerDistFromExit / fSlowDistFromExit;
            if (fPlayerDistFromExit < this.getDistFromExit(PlayerModel.x - xVel, PlayerModel.y + yVel)) {
                yVel = (float)((double)yVel * 0.75);
                xVel = (float)((double)xVel * 0.75);
            }
        }
        GL11.glEnable(3042);
        GL11.glBegin(9);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, fFadeAlpha);
        GL11.glVertex2d(0.0, 0.0);
        GL11.glVertex2d(Constants.VIEW_WIDTH, 0.0);
        GL11.glVertex2d(Constants.VIEW_WIDTH, Constants.VIEW_HEIGHT);
        GL11.glVertex2d(0.0, Constants.VIEW_HEIGHT);
        GL11.glVertex2d(0.0, 0.0);
        GL11.glEnd();
        GL11.glDisable(3042);
    }

    private void drawScoreAlpha() {
        int left;
        int middle;
        int right;
        float scoreFadeRight = 0.0f;
        float scoreFadeLeft = 0.0f;
        if (offsetX > 0.0f && offsetX < (float)Constants.VIEW_WIDTH) {
            float temp = offsetX / (float)(Constants.VIEW_WIDTH / 3);
            scoreFadeRight = temp / 2.0f;
            scoreFadeLeft = 1.0f - scoreFadeRight;
            right = Constants.VIEW_WIDTH;
            middle = 0;
            left = -Constants.VIEW_WIDTH;
        } else if (offsetX <= 0.0f && offsetX > (float)(-Constants.VIEW_WIDTH)) {
            float temp = -offsetX / (float)(Constants.VIEW_WIDTH / 3);
            scoreFadeLeft = temp / 2.0f;
            scoreFadeRight = 1.0f - scoreFadeLeft;
            middle = Constants.VIEW_WIDTH;
            left = 0;
            right = Constants.VIEW_WIDTH * 2;
        } else if (offsetX >= (float)Constants.VIEW_WIDTH && offsetX < (float)(3 * Constants.VIEW_WIDTH)) {
            float temp = (offsetX - (float)Constants.VIEW_WIDTH) / (float)(Constants.VIEW_WIDTH / 3);
            scoreFadeRight = temp / 2.0f;
            scoreFadeLeft = 1.0f - scoreFadeRight;
            right = 0;
            middle = -Constants.VIEW_WIDTH - 150;
            left = -2 * Constants.VIEW_WIDTH;
        } else {
            right = 0;
            left = 0;
            middle = 0;
        }
        GL11.glEnable(3042);
        GL11.glBegin(9);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, scoreFadeRight);
        GL11.glVertex2d((float)middle + offsetX, 0.0f + offsetY);
        GL11.glVertex2d((float)right + offsetX, 0.0f + offsetY);
        GL11.glVertex2d((float)right + offsetX, (float)Constants.VIEW_HEIGHT + offsetY);
        GL11.glVertex2d((float)middle + offsetX, (float)Constants.VIEW_HEIGHT + offsetY);
        GL11.glVertex2d((float)middle + offsetX, 0.0f + offsetY);
        GL11.glEnd();
        GL11.glBegin(9);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, scoreFadeLeft);
        GL11.glVertex2d((float)left + offsetX, 0.0f + offsetY);
        GL11.glVertex2d((float)middle + offsetX, 0.0f + offsetY);
        GL11.glVertex2d((float)middle + offsetX, (float)Constants.VIEW_HEIGHT + offsetY);
        GL11.glVertex2d((float)left + offsetX, (float)Constants.VIEW_HEIGHT + offsetY);
        GL11.glVertex2d((float)left + offsetX, 0.0f + offsetY);
        GL11.glEnd();
        GL11.glDisable(3042);
    }

    public float getDistFromExit(float xInput, float yInput) {
        float xDist = xInput - (float)this.exitButton.xLoc + (float)Button.xOffset;
        float yDist = yInput - (float)this.exitButton.yLoc - (float)Button.yOffset;
        return (float)Math.sqrt(xDist * xDist + yDist * yDist);
    }

    public void moveUp() {
        if (yVel < 10.0f) {
            yVel += Constants.PLAYER_SPEED_INCREASE;
        }
    }

    public void moveDown() {
        if (yVel > -10.0f) {
            yVel -= Constants.PLAYER_SPEED_INCREASE;
        }
    }

    public void moveRight() {
        if (xVel > -10.0f) {
            xVel -= Constants.PLAYER_SPEED_INCREASE;
        }
    }

    public void moveLeft() {
        if (xVel < 10.0f) {
            xVel += Constants.PLAYER_SPEED_INCREASE;
        }
    }

    public void applyFriction() {
        if (xVel > 0.0f && (xVel -= Constants.PLAYER_SPEED_FRICTION) < 0.0f) {
            xVel = 0.0f;
        }
        if (xVel < 0.0f && (xVel += Constants.PLAYER_SPEED_FRICTION) > 0.0f) {
            xVel = 0.0f;
        }
        if (yVel > 0.0f && (yVel -= Constants.PLAYER_SPEED_FRICTION) < 0.0f) {
            yVel = 0.0f;
        }
        if (yVel < 0.0f && (yVel += Constants.PLAYER_SPEED_FRICTION) > 0.0f) {
            yVel = 0.0f;
        }
    }

    public void executeButtonAction(Button inputButton) {
        if (inputButton.equals(this.playButton)) {
            MainControl.songBegin = true;
            Game.startGame();
        } else if (inputButton.equals(this.exitButton)) {
            MainControl.scoreControl.writeToFile();
            System.exit(1);
        }
    }

    public static void menuReset() {
        offsetX = 0.0f;
        offsetY = 0.0f;
        xVel = 0.0f;
        yVel = 0.0f;
    }

    public static void drawArrowKey(int xLoc, int yLoc, double dScale, float fRotation, boolean bHighlight) {
        if (bHighlight) {
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glRectf((float)xLoc - Fonts.getWidth("a", dScale), (float)yLoc - Fonts.getHeight("a", dScale), (float)xLoc + Fonts.getWidth("a", dScale), (float)yLoc + Fonts.getHeight("a", dScale));
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
        } else {
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
        }
        GL11.glPushMatrix();
        int iTriangleSize = (int)(16.0 * dScale);
        GL11.glTranslatef(xLoc, (float)yLoc + (float)iTriangleSize / 2.0f, 0.0f);
        GL11.glRotatef(fRotation, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(0);
        int j = 0;
        while (j <= iTriangleSize) {
            int i = 0;
            while (i < j) {
                GL11.glVertex2d(i, (double)(j - 2) - (double)iTriangleSize / 2.0);
                GL11.glVertex2d(-i, (double)(j - 2) - (double)iTriangleSize / 2.0);
                ++i;
            }
            ++j;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glBegin(3);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glVertex2d((float)xLoc - Fonts.getWidth("a", dScale), (float)yLoc - Fonts.getHeight("a", dScale));
        GL11.glVertex2d((float)xLoc + Fonts.getWidth("a", dScale), (float)yLoc - Fonts.getHeight("a", dScale));
        GL11.glVertex2d((float)xLoc + Fonts.getWidth("a", dScale), (float)yLoc + Fonts.getHeight("a", dScale));
        GL11.glVertex2d((float)xLoc - Fonts.getWidth("a", dScale), (float)yLoc + Fonts.getHeight("a", dScale));
        GL11.glVertex2d((float)xLoc - Fonts.getWidth("a", dScale), (float)yLoc - Fonts.getHeight("a", dScale));
        GL11.glEnd();
    }

    public static void drawKey(int xLoc, int yLoc, double dScale, String sKey, boolean bHighlight) {
        if (bHighlight) {
            String keyToUse = null;
            if (sKey.length() == 1) {
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                keyToUse = "a";
            } else {
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                keyToUse = sKey;
            }
            GL11.glRectf((float)xLoc - Fonts.getWidth(keyToUse, dScale), (float)yLoc - Fonts.getHeight(keyToUse, dScale), (float)xLoc + Fonts.getWidth(keyToUse, dScale), (float)yLoc + Fonts.getHeight(keyToUse, dScale));
            Fonts.drawText(xLoc, yLoc, dScale, sKey, Color.black, true);
        } else {
            Fonts.drawText(xLoc, yLoc, dScale, sKey, true);
        }
        if (sKey.length() == 1) {
            sKey = "a";
        }
        GL11.glBegin(3);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glVertex2d((float)xLoc - Fonts.getWidth(sKey, dScale), (float)yLoc - Fonts.getHeight(sKey, dScale));
        GL11.glVertex2d((float)xLoc + Fonts.getWidth(sKey, dScale), (float)yLoc - Fonts.getHeight(sKey, dScale));
        GL11.glVertex2d((float)xLoc + Fonts.getWidth(sKey, dScale), (float)yLoc + Fonts.getHeight(sKey, dScale));
        GL11.glVertex2d((float)xLoc - Fonts.getWidth(sKey, dScale), (float)yLoc + Fonts.getHeight(sKey, dScale));
        GL11.glVertex2d((float)xLoc - Fonts.getWidth(sKey, dScale), (float)yLoc - Fonts.getHeight(sKey, dScale));
        GL11.glEnd();
    }

    public void draw() {
        GL11.glPushMatrix();
        GL11.glTranslatef(fadeOffX, fadeOffY, 0.0f);
        boolean bUpPressed = KeyboardInput.isKeyActive(200);
        MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(110.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "w", bUpPressed);
        MenuControl.drawArrowKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(110.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, 0.0f, bUpPressed);
        boolean bDownPressed = KeyboardInput.isKeyActive(208);
        MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "s", bDownPressed);
        MenuControl.drawArrowKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, 180.0f, bDownPressed);
        boolean bLeftPressed = KeyboardInput.isKeyActive(203);
        MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(15.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "a", bLeftPressed);
        MenuControl.drawArrowKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(85.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, 270.0f, bLeftPressed);
        boolean bRightPressed = KeyboardInput.isKeyActive(205);
        MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(85.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "d", bRightPressed);
        MenuControl.drawArrowKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(15.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, 90.0f, bRightPressed);
        if (Game.getMillisecondTimeSinceStart() / 1000L > 30L) {
            MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(170.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "shift", KeyboardInput.isKeyActive(54));
            MenuControl.drawKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(170.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(75.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "shift", KeyboardInput.isKeyActive(54));
        }
        MenuControl.drawKey(Constants.VIEW_WIDTH * 35 / 800 + (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(35.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "space", KeyboardInput.isKeyActive(57));
        MenuControl.drawKey(Constants.VIEW_WIDTH - Constants.VIEW_WIDTH * 35 / 800 - (int)(50.0f * Fonts.resolutionScale) + (int)offsetX, Constants.VIEW_HEIGHT - (int)(35.0f * Fonts.resolutionScale) + (int)offsetY, 0.5, "space", KeyboardInput.isKeyActive(57));
        for (Button b : this.buttonList) {
            b.draw();
        }
        GL11.glPopMatrix();
    }

    public void fadeToBlack() {
        Constants.SCORE = 0;
        Constants.MULTIPLIER = 1;
        fadeOffY = (int)((float)fadeOffY + yVel);
        fadeOffX = (int)((float)fadeOffX + xVel);
        this.draw();
        StaticDrawer.fade(0.0f, 0.0f, Constants.VIEW_WIDTH, Constants.VIEW_HEIGHT, fade += 0.03f);
        Fonts.drawText(60.0f, 30.0f, 1.0, "x" + Integer.toString(Constants.MULTIPLIER), true);
        Fonts.drawText(Constants.VIEW_WIDTH - 80, 30.0f, 1.0, Integer.toString(Constants.SCORE), true);
        StaticDrawer.fade(0.0f, 0.0f, 100.0f, 75.0f, 1.0f - fade);
        StaticDrawer.fade(Constants.VIEW_WIDTH - 100, 0.0f, 100.0f, 75.0f, 1.0f - fade);
        if (fade >= 1.0f) {
            MainControl.songBegin = false;
            fadeOffY = 0;
            fadeOffX = 0;
            fade = 0.0f;
            MenuControl.menuReset();
        }
    }
}

